function obj=marche(varargin)
% MARCHE est le constructeur de l'objet informatique "marche d'nergie potentielle".
%   Cette classe est destine  stocker les caractristiques
%   (proprits) physiques d'une marche d'nergie potentielle.
%
%   obj=MARCHE(varargin)
%   Appel avec aucun argument, il retourne un objet vide.
%   Appel avec un argument (un objet informatique marche), il retourne l'objet informatique.
%   Appel avec 6 arguments:
%       >> nom  =  nom de la marche;
%       >> x    =  position de la marche sur l'axe des x;
%       >> Epe  =  nergie potentielle en entre;
%       >> Eps  =  nergie potentielle en sortie;
%       >> ke   =  vecteur d'onde en entre;
%       >> ks   =  vecteur d'onde en sortie,
%
%       << obj  =  objet informatique marche.
%
%   Olivier Pujol : septembre 2013
%
switch (nargin)
    case 0
        obj.name=[];
        obj.x   =[];
        obj.Epe =[];
        obj.Eps =[];
        obj.ke  =[];
        obj.ks  =[];
        obj     =class(obj,'marche');
    case 1
        if (isa(varargin{1},'marche'))
            obj=varargin{1};
        else
            error('Type d''objet faux !');
        end
    case 6
        obj.name=varargin{1};
        obj.x   =varargin{2};
        obj.Epe =varargin{3};
        obj.Eps =varargin{4};
        obj.ke  =varargin{5};
        obj.ks  =varargin{6};
        obj=class(obj,'marche');
    otherwise
        error('Mauvais nombre d''argument d''entre !');
end
%
return;